// $Id: CTriStateImage.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CTriStateImage.hpp"
using Exponent::GUI::Controls::CTriStateImage;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CTriStateImage, CControl);

//	===========================================================================
CTriStateImage::CTriStateImage(IControlRoot *root, const long uniqueId, const CRect &area) 
			  : CControl(root, uniqueId, area)
			  , m_currentState(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CTriStateImage);

	NULL_POINTER(m_images[0]);
	NULL_POINTER(m_images[1]);
	NULL_POINTER(m_images[2]);
	this->controlIsMouseEnabled(false);
}

//	===========================================================================
CTriStateImage::~CTriStateImage()
{
	EXPONENT_CLASS_DESTRUCTION(CTriStateImage);
	FORGET_COUNTED_OBJECT(m_images[0]);
	FORGET_COUNTED_OBJECT(m_images[1]);
	FORGET_COUNTED_OBJECT(m_images[2]);
}

//	===========================================================================
void CTriStateImage::drawControl(CGraphics &graphics)
{
	// Check if we shoudl draw
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	if (m_images[m_currentState])
	{
		graphics.drawImage(m_images[m_currentState], m_normalisedArea, m_images[m_currentState]->getNormalisedImageSize());
	}
}

//	===========================================================================
void CTriStateImage::setImages(IImage *image1, IImage *image2, IImage *image3)
{
	EXCHANGE_COUNTED_OBJECTS(m_images[0], image1);
	EXCHANGE_COUNTED_OBJECTS(m_images[1], image2);
	EXCHANGE_COUNTED_OBJECTS(m_images[2], image3);
}

//	===========================================================================
void CTriStateImage::setState(const long state)
{
	if (state >= 0 && state < 3)
	{
		m_currentState = state;
		this->update();
	}
}